import { string } from 'alga-js'
import strapiHelper from "../../../../utils/strapiHelper"

export default defineEventHandler(async (event) => {
  let data: any = {}
  const id = getRouterParam(event, 'id')
  const table = getRouterParam(event, 'table')

  try {
    const res: any = await strapiHelper(event, `ad-attachments/${id}?populate=attachment`, 'GET', null)
    if(res?.data) {
      data = res.data?.attachment || []
      /* ?.map((item: any) => {
        return {
          id: item.id,
          ...item.attributes
        }
      }) */
    }
  } catch(error: any) {
    data = {
      status: error.status || error.statusCode || 500,
      message: error.detail || error.message || error.statusMessage
    }
  }

  return data
})